<?php get_header(); ?>

	<div class="contentwrapper">
		<div class="body">
			<?php if (get_option("frontpageshowpremium") == 1) { ?>
			<!-- PREMIUM PROFILES start -->
	    	<div class="bodybox bodybox-homepage">
	        	<h3 class="l"><?php _de('Premium %s',304,ucwords($taxonomy_profile_name_plural)); ?></h3>
	        	<a class="see-all-top bluebutton rad25 r" href="<?php echo get_permalink(get_option( "all_premium_profiles_page_id")); ?>"><?php _de("All premium %s",1080,$taxonomy_profile_name_plural); ?></a>
	        	<div class="clear"></div>
				<?php
				$args = array(
					'post_type' => $taxonomy_profile_url,
					'orderby' => 'meta_value_num', 'meta_key' => 'premium_since',
					'meta_query' => array( array('key' => 'premium', 'value' => '1', 'compare' => '=', 'type' => 'NUMERIC') ),
					'posts_per_page' => get_option("frontpageshowpremiumcols") * 5
				);
				$premium_profiles = new WP_Query( $args );
				$i = "1";
				if ($premium_profiles->have_posts()) :
					while ( $premium_profiles->have_posts() ) : $premium_profiles->the_post();
						include (get_template_directory() . '/loop-show-profile.php');
					endwhile;
				else:
					_de('No premium %s yet',305,$taxonomy_profile_name_plural);
				endif;
				wp_reset_postdata();
				?>
	            <div class="clear"></div>
	        	<a class="see-all-bottom bluebutton rad25 text-center hide" href="<?php echo get_permalink(get_option( "all_premium_profiles_page_id")); ?>"><?php _de("All premium %s",1080,$taxonomy_profile_name_plural); ?></a>
	        	<div class="see-more-button bluebutton rad25 text-center hide"><?php _de('See more',1261) ?></div>
	        </div> <!-- BODY BOX -->
			<!-- PREMIUM PROFILES end -->
			<?php } // if $frontpageshowpremium = 1 ?>


			<?php if (get_option("frontpageshownormal") == 1) { ?>
			<!-- NORMAL PROFILES start -->
	    	<div class="bodybox bodybox-homepage">
	        	<h3 class="l"><?php _de('Newly Added %s',306,ucwords($taxonomy_profile_name_plural)); ?></h3>
	        	<a class="see-all-top bluebutton rad25 r" href="<?php echo get_permalink(get_option("all_new_profiles_page_id")); ?>"><?php _de("All newly added %s",1082,$taxonomy_profile_name_plural); ?></a>
	        	<div class="clear"></div>
				<?php
				$args = array(
					'post_type' => $taxonomy_profile_url,
					'meta_query' => array( array('key' => 'premium', 'value' => '0', 'compare' => '=', 'type' => 'NUMERIC') ),
					'posts_per_page' => get_option("frontpageshownormalcols") * 5
				);
				$normal_profiles = new WP_Query( $args );
				$i = "1";
				if ($normal_profiles->have_posts()) :
					while ( $normal_profiles->have_posts() ) : $normal_profiles->the_post();
						include (get_template_directory() . '/loop-show-profile.php');
					endwhile;
				else:
					_de('No %s here yet',29,$taxonomy_profile_name_plural);
				endif;
				wp_reset_postdata();
				?>
	            <div class="clear"></div>
	            <a class="see-all-bottom bluebutton rad25 text-center hide" href="<?php echo get_permalink(get_option("all_new_profiles_page_id")); ?>"><?php _de("All newly added %s",1082,$taxonomy_profile_name_plural); ?></a>
	            <div class="see-more-button bluebutton rad25 text-center hide"><?php _de('See more',1261) ?></div>
	        </div> <!-- BODY BOX -->
			<!-- NORMAL PROFILES end -->
			<?php } // if $frontpageshownormal = 1 ?>


			<?php if (get_option("frontpageshowrev") == 1) { ?>
			<?php
			$args = array(
				'post_type' => 'review',
				'posts_per_page' => get_option("frontpageshowrevitems"),
				'orderby' => 'date'
			);
			$reviews_query = new WP_Query( $args );
			if ( $reviews_query->have_posts() ) : 
			?>
			<!-- REVIEWS start -->
	    	<div class="bodybox bodybox-homepage">
	        	<h3 class="l"><?php _de('Latest %s Reviews',307,ucwords($taxonomy_profile_name_plural)); ?>:</h3>
	            <a class="see-all-top bluebutton rad25 r" href="<?php echo get_permalink(get_option('nav_reviews_page_id')); ?>"><?php _de('See all reviews',308); ?></a>
	            <div class="clear"></div>
			    <?php while ( $reviews_query->have_posts() ) : $reviews_query->the_post(); ?>
				<div class="onereviewtext onereviewtext-homepage">
					<div class="author l"><span><?php echo substr(get_the_author_meta('display_name'), 0, 2) ?>...</span> <?php _de('wrote',309); ?>:</div>
					<div class="rating r">
						<div class="starrating l"><div class="starrating_stars star<?php echo get_post_meta(get_the_ID(), 'rateescort', true); ?>"></div></div>
					</div>
				    <div class="clear5"></div>
					<div class="reviewtext">
					    <?php
				        echo substr(strip_tags(get_the_content()), 0, get_option("frontpageshowrevchars"));
						if (strlen(get_the_content()) > get_option("frontpageshowrevchars")) {
							echo '...';
						}
						echo ' <a href="'.get_permalink().'">'._d('see the review',310).'</a>';
						?>
				    </div> <!-- REVIEW TEXT -->
				</div> <!-- ONE REVIEW -->
				<?php endwhile; ?>
	            <div class="clear10"></div>
	            <a class="see-all-bottom bluebutton rad25 center hide" href="<?php echo get_permalink(get_option('nav_reviews_page_id')); ?>"><?php _de('See all reviews',308); ?></a>
	        </div> <!-- BODY BOX -->
			<!-- REVIEWS end -->
			<?php
			else:
				// _de('No reviews yet',311);
			endif;
			wp_reset_postdata();
			?>
			<?php } // if $frontpageshowrev = 1 ?>
	    </div> <!-- BODY -->
    </div> <!-- contentwrapper -->

	<?php get_sidebar("left"); ?>
	<?php get_sidebar("right"); ?>
	<div class="clear"></div>

<?php get_footer(); ?>