<?php
if(!defined('error_reporting')) { define('error_reporting', '0'); }
ini_set( 'display_errors', error_reporting );
if(error_reporting == '1') { error_reporting( E_ALL ); }
if(isdolcetheme !== 1) { die(); }

global $taxonomy_profile_name, $taxonomy_profile_name_plural;

function generate_payment_buttons($p, $id, $text="") {
	/*
	$id = id to upgrade
	$p = payment type
	$p legend:
	1 for premium
	2 for featured
	3 for tour
	4 for escort unlock
	5 VIP status
	6 agency registration
	7 agency adding escort
	8 independent escort registration
	*/
	$paymentgateway = get_option("paymentgateway");

	if ($paymentgateway == "2") { // Payza
		return generate_payza_button($p, $id, $text);
	} elseif ($paymentgateway == "3") { // PayPal
		return generate_paypal_button($p, $id, $text);
	} elseif ($paymentgateway == "4") { // Other
		return generate_other_payment_option($p, $id, $text);
	} elseif ($paymentgateway == "5") { // CCBill
		return generate_ccbill_button($p, $id, $text);
	} else {
		return false;
	}
}

function generate_payza_button($p, $id, $text) {
	global $payment_options_a;
	$ap_purchasetype = "item";
	$ap_returnurl = get_permalink($id);
	if($p == "1") { // premium
		$ap_itemname = _d('Premium Position',634);
		$ap_amount = number_format(get_option("premiumprice"), 2, '.', '');
		$ap_description = _d('Buy Premium Position',636);
		$submit = _d('Buy Now',816);
		if(get_option("premiumsubscription") == "yes") {
			$premiumduration = get_option("premiumduration");
			$ap_purchasetype = "subscription";
			$subscription_fields = '<input type="hidden" name="ap_timeunit" value="'.$payment_options_a[$premiumduration][1].'">';
			$subscription_fields .= '<input type="hidden" name="ap_periodlength" value="'.$payment_options_a[$premiumduration][3].'">';
			$subscription_fields .= '<input type="hidden" name="ap_periodcount" value="0">';
		}
	} elseif ($p == "2") { // featured
		$ap_itemname = _d('Featured Position',641);
		$ap_amount = number_format(get_option("featuredprice"), 2, '.', '');
		$ap_description = _d('Buy Featured Position',636);
		$submit = _d('Buy Now',816);
		if(get_option("featuredsubscription") == "yes") {
			$featuredduration = get_option("featuredduration");
			$ap_purchasetype = "subscription";
			$subscription_fields = '<input type="hidden" name="ap_timeunit" value="'.$payment_options_a[$featuredduration][1].'">';
			$subscription_fields .= '<input type="hidden" name="ap_periodlength" value="'.$payment_options_a[$featuredduration][3].'">';
			$subscription_fields .= '<input type="hidden" name="ap_periodcount" value="0">';
		}
	} elseif ($p == "3") { // tour
		$ap_itemname = _d('Activate tour',788);
		$ap_amount = number_format(get_option("tourprice"), 2, '.', '');
		$ap_description = _d('Activate tour',788);
		$submit = _d('Pay for this tour',559);
		$ap_returnurl = get_bloginfo('url');
	} elseif ($p == "4") { // unlock escort information
		$ap_itemname = _d('Unlock profile',876);
		$ap_amount = number_format(get_option("vipprice"), 2, '.', '');
		$ap_description = _d('Unlock profile',876);
		$submit = _d('Unlock profile',876);
		$ap_returnurl = get_bloginfo('url');
	} elseif ($p == "5") { // VIP status
		$ap_itemname = _d('Get VIP status',880);
		$ap_amount = number_format(get_option("vipprice"), 2, '.', '');
		$ap_description = _d('Get VIP status',880);
		$submit = _d('Get VIP status',880);
		if(get_option("vipsubscription") == "yes") {
			$vipduration = get_option("vipduration");
			$ap_purchasetype = "subscription";
			$subscription_fields = '<input type="hidden" name="ap_timeunit" value="'.$payment_options_a[$vipduration][1].'">';
			$subscription_fields .= '<input type="hidden" name="ap_periodlength" value="'.$payment_options_a[$vipduration][3].'">';
			$subscription_fields .= '<input type="hidden" name="ap_periodcount" value="0">';
		}
		$ap_returnurl = get_bloginfo('url');
	} elseif ($p == "6") { // agency registration
		$ap_itemname = _d('Registration fee',925);
		$ap_amount = number_format(get_option("agregprice"), 2, '.', '');
		$ap_description = _d('Registration fee',925);
		$submit = _d('Pay registration fee',926);
		if(get_option("agregsubscription") == "yes") {
			$vipduration = get_option("agregduration");
			$ap_purchasetype = "subscription";
			$subscription_fields = '<input type="hidden" name="ap_timeunit" value="'.$payment_options_a[$vipduration][1].'">';
			$subscription_fields .= '<input type="hidden" name="ap_periodlength" value="'.$payment_options_a[$vipduration][3].'">';
			$subscription_fields .= '<input type="hidden" name="ap_periodcount" value="0">';
		}
	} elseif ($p == "7") { // agency adding escort
		$ap_itemname = _d('Registration fee',925);
		$ap_amount = number_format(get_option("agescortregprice"), 2, '.', '');
		$ap_description = _d('Registration fee',925);
		$submit = _d('Pay registration fee',926);
		if(get_option("agescortregsubscription") == "yes") {
			$vipduration = get_option("agescortregduration");
			$ap_purchasetype = "subscription";
			$subscription_fields = '<input type="hidden" name="ap_timeunit" value="'.$payment_options_a[$vipduration][1].'">';
			$subscription_fields .= '<input type="hidden" name="ap_periodlength" value="'.$payment_options_a[$vipduration][3].'">';
			$subscription_fields .= '<input type="hidden" name="ap_periodcount" value="0">';
		}
	} elseif ($p == "8") { // independent escort registration
		$ap_itemname = _d('Registration fee',925);
		$ap_amount = number_format(get_option("indescregprice"), 2, '.', '');
		$ap_description = _d('Registration fee',925);
		$submit = _d('Pay registration fee',926);
		if(get_option("indescregsubscription") == "yes") {
			$vipduration = get_option("indescregduration");
			$ap_purchasetype = "subscription";
			$subscription_fields = '<input type="hidden" name="ap_timeunit" value="'.$payment_options_a[$vipduration][1].'">';
			$subscription_fields .= '<input type="hidden" name="ap_periodlength" value="'.$payment_options_a[$vipduration][3].'">';
			$subscription_fields .= '<input type="hidden" name="ap_periodcount" value="0">';
		}
	}

	if($text) { $submit = $text; } // if the function is being called with a custom text then change the button's text with this one
	$button  = '<form method="post" action="https://secure.payza.com/checkout">';
	if(get_option("paymentsandbox")) {
		$button .= '<input type="hidden" name="ap_testmode" value="1" />';
	}
	$button .= $subscription_fields;
	$button .= '<input type="hidden" name="ap_merchant" value="'.get_option("payzaemail").'" />';
	$button .= '<input type="hidden" name="ap_purchasetype" value="'.$ap_purchasetype.'" />';
	$button .= '<input type="hidden" name="ap_itemname" value="'.$ap_itemname.'" />';
	$button .= '<input type="hidden" name="ap_amount" value="'.$ap_amount.'" />';
	$button .= '<input type="hidden" name="ap_currency" value="'.get_option("creditcurrency").'" />';
	$button .= '<input type="hidden" name="ap_description" value="'.$ap_description.'" />';
	$button .= '<input type="hidden" name="ap_itemcode" value="'.$p.'" />';
	$button .= '<input type="hidden" name="ap_returnurl" value="'.$ap_returnurl.'" />';
	$button .= '<input type="hidden" name="ap_cancelurl" value="'.get_bloginfo('url').'" />';
	$button .= '<input type="hidden" name="apc_1" value="'.$id.'" />';
	$button .= '<input type="hidden" name="ap_alerturl" value="'.get_bloginfo('template_url').'/IPN.php" />';
	$button .= '<input type="hidden" name="ap_ipnversion" value="2" />';
	$button .= '<input type="submit" class="greenbutton payment-button rad3" name="submit" value="'.$submit.'" /><br />';
	$button .= '</form>';
	return $button;
}
function generate_paypal_button($p, $id, $text) {
	global $payment_options_a;
	$button_type = "_xclick";
	$amount_type = "amount";
	$return_url = get_permalink($id);
	if($p == "1") { // premium
		$pp_itemname = _d('Premium Position',634);
		$pp_amount = number_format(get_option("premiumprice"), 2, '.', '');
		$submit = _d('Buy Now',816);
		if(get_option("premiumsubscription") == "yes") {
			$premiumduration = get_option("premiumduration");
			$button_type = "_xclick-subscriptions";
			$amount_type = "a3";
			$subscription_fields = '<input type="hidden" name="p3" value="'.$payment_options_a[$premiumduration][3].'">';
			$subscription_fields .= '<input type="hidden" name="t3" value="'.$payment_options_a[$premiumduration][2].'">';
			$subscription_fields .= '<input type="hidden" name="src" value="1">';
			$subscription_fields .= '<input type="hidden" name="sra" value="1">';
			$subscription_fields .= '<input type="hidden" name="modify" value="0">';
			/* modify:
			0 – allows subscribers only to sign up for new subscriptions
			1 – allows subscribers to sign up for new subscriptions and modify their current subscriptions
			2 – allows subscribers to modify only their current subscriptions
			*/
		}
	} elseif ($p == "2") { // featured
		$pp_itemname = _d('Featured Position',641);
		$pp_amount = number_format(get_option("featuredprice"), 2, '.', '');
		$submit = _d('Buy Now',816);
		if(get_option("featuredsubscription") == "yes") {
			$featuredduration = get_option("featuredduration");
			$button_type = "_xclick-subscriptions";
			$amount_type = "a3";
			$subscription_fields = '<input type="hidden" name="p3" value="'.$payment_options_a[$featuredduration][3].'">';
			$subscription_fields .= '<input type="hidden" name="t3" value="'.$payment_options_a[$featuredduration][2].'">';
			$subscription_fields .= '<input type="hidden" name="src" value="1">';
			$subscription_fields .= '<input type="hidden" name="sra" value="1">';
			$subscription_fields .= '<input type="hidden" name="modify" value="0">';
		}
	} elseif ($p == "3") { // tour
		$pp_itemname = _d('Activate tour',788);
		$pp_amount = number_format(get_option("tourprice"), 2, '.', '');
		$submit = _d('Pay for this tour',559);
		$return_url = get_bloginfo('url');
	} elseif ($p == "4") { // unlock escort information
		$pp_itemname = _d('Unlock profile',876);
		$pp_amount = number_format(get_option("vipprice"), 2, '.', '');
		$submit = _d('Unlock profile',876);
		$escortid = explode("-", $id);
		$escortid = $custom[1];
		$return_url = get_permalink($escortid);
	} elseif ($p == "5") { // VIP status
		$pp_itemname = _d('Get VIP status',880);
		$pp_amount = number_format(get_option("vipprice"), 2, '.', '');
		$submit = _d('Get VIP status',880);
		if(get_option("vipsubscription") == "yes") {
			$vipduration = get_option("vipduration");
			$button_type = "_xclick-subscriptions";
			$amount_type = "a3";
			$subscription_fields = '<input type="hidden" name="p3" value="'.$payment_options_a[$vipduration][3].'">';
			$subscription_fields .= '<input type="hidden" name="t3" value="'.$payment_options_a[$vipduration][2].'">';
			$subscription_fields .= '<input type="hidden" name="src" value="1">';
			$subscription_fields .= '<input type="hidden" name="sra" value="1">';
			$subscription_fields .= '<input type="hidden" name="modify" value="0">';
		}
		$return_url = get_bloginfo('url');
	} elseif ($p == "6") { // agency registration
		$pp_itemname = _d('Registration fee',925);
		$pp_amount = number_format(get_option("agregprice"), 2, '.', '');
		$submit = _d('Pay registration fee',926);
		if(get_option("agregsubscription") == "yes") {
			$vipduration = get_option("agregduration");
			$button_type = "_xclick-subscriptions";
			$amount_type = "a3";
			$subscription_fields = '<input type="hidden" name="p3" value="'.$payment_options_a[$vipduration][3].'">';
			$subscription_fields .= '<input type="hidden" name="t3" value="'.$payment_options_a[$vipduration][2].'">';
			$subscription_fields .= '<input type="hidden" name="src" value="1">';
			$subscription_fields .= '<input type="hidden" name="sra" value="1">';
			$subscription_fields .= '<input type="hidden" name="modify" value="0">';
		}
	} elseif ($p == "7") { // agency adding escort
		$pp_itemname = _d('Registration fee',925);
		$pp_amount = number_format(get_option("agescortregprice"), 2, '.', '');
		$submit = _d('Pay registration fee',926);
		if(get_option("agescortregsubscription") == "yes") {
			$vipduration = get_option("agescortregduration");
			$button_type = "_xclick-subscriptions";
			$amount_type = "a3";
			$subscription_fields = '<input type="hidden" name="p3" value="'.$payment_options_a[$vipduration][3].'">';
			$subscription_fields .= '<input type="hidden" name="t3" value="'.$payment_options_a[$vipduration][2].'">';
			$subscription_fields .= '<input type="hidden" name="src" value="1">';
			$subscription_fields .= '<input type="hidden" name="sra" value="1">';
			$subscription_fields .= '<input type="hidden" name="modify" value="0">';
		}
	} elseif ($p == "8") { // independent escort registration
		$pp_itemname = _d('Registration fee',925);
		$pp_amount = number_format(get_option("indescregprice"), 2, '.', '');
		$submit = _d('Pay registration fee',926);
		if(get_option("indescregsubscription") == "yes") {
			$vipduration = get_option("indescregduration");
			$button_type = "_xclick-subscriptions";
			$amount_type = "a3";
			$subscription_fields = '<input type="hidden" name="p3" value="'.$payment_options_a[$vipduration][3].'">';
			$subscription_fields .= '<input type="hidden" name="t3" value="'.$payment_options_a[$vipduration][2].'">';
			$subscription_fields .= '<input type="hidden" name="src" value="1">';
			$subscription_fields .= '<input type="hidden" name="sra" value="1">';
			$subscription_fields .= '<input type="hidden" name="modify" value="0">';
		}
	}
	if(get_option("paymentsandbox")) {
		$formurl = "https://www.sandbox.paypal.com/cgi-bin/webscr";
	} else {
		$formurl = "https://www.paypal.com/cgi-bin/webscr";
	}
	if($text) { $submit = $text; } // if the function is being called with a custom text then change the button's text with this one
	$button  = '<form method="post" action="'.$formurl.'">';
	$button .= '<input type="hidden" name="cmd" value="'.$button_type.'">';
	$button .= $subscription_fields;
	$button .= '<input type="hidden" name="business" value="'.get_option("paypalemail").'">';
	$button .= '<input type="hidden" name="item_number" value="'.$p.'">';
	$button .= '<input type="hidden" name="item_name" value="'.$pp_itemname.'">';
	$button .= '<input type="hidden" name="'.$amount_type.'" value="'.$pp_amount.'">';
	$button .= '<input type="hidden" name="currency_code" value="'.get_option("creditcurrency").'">';
	$button .= '<input type="hidden" name="no_note" value="1">';
	$button .= '<input type="hidden" name="notify_url" value="'.get_bloginfo('template_url').'/IPN.php">';
	$button .= '<input type="hidden" name="custom" value="'.$id.'">';
	$button .= '<input type="hidden" name="return" value="'.$return_url.'">';
	$button .= '<input type="submit" class="greenbutton payment-button rad3" name="submit" value="'.$submit.'" /><br />';
	$button .= '</form>';
	return $button;
}
function generate_other_payment_option($p, $id) {
	$otherpaymentoption = nl2br(stripslashes(get_option("otherpaymentoption")));
	$agregother = nl2br(stripslashes(get_option("agregother")));
	$agescortregother = nl2br(stripslashes(get_option("agescortregother")));
	$indescregother = nl2br(stripslashes(get_option("indescregother")));
	$premiumother = nl2br(stripslashes(get_option("premiumother")));
	$featuredother = nl2br(stripslashes(get_option("featuredother")));
	$tourother = nl2br(stripslashes(get_option("tourother")));
	$vipother = nl2br(stripslashes(get_option("vipother")));

	$info .= '<br />'._d('Follow the instructions bellow to make the payment',978).':<br />';
	$info .= '<div class="ok rad3">'.$otherpaymentoption.'</div>';
	$info2 = '<div class="err rad3">'._d('After payment is made contact us with the help of our contact form and tell us',979).' ';
	if($p == "1") { // premium
		$info .= '<div class="ok rad3">'.$premiumother.'</div>'.$info2;
		$info .= _d('your profile url',980).'. ';
		$info .= _d('We\'ll activate your premium status for you',981).'.';
	} elseif ($p == "2") { // featured
		$info .= '<div class="ok rad3">'.$featuredother.'</div>'.$info2;
		$info .= _d('your profile url',980).'. ';
		$info .= _d('We\'ll activate your featured status for you',982).'.';
	} elseif ($p == "3") { // tour
		$info .= '<div class="ok rad3">'.$tourother.'</div>'.$info2;
		$info .= _d('your tour ID',983).'. ';
		$info .= _d('We\'ll activate your tour for you',984).'.<br />';
		$info .= _d('Your TOUR ID',985).': <u>'.$id.'</u>';
	} elseif ($p == "4") { // unlock escort information
		$info .= '<div class="ok rad3">'.$vipother.'</div>'.$info2;
		$info .= _d('the url of the %s you want to unlock and your user ID',986,$taxonomy_profile_name).'. ';
		$info .= _d('We\'ll unlock the %s for you',987,$taxonomy_profile_name).'.<br />';
		$info .= _d('Your USER ID',990).': <u>'.$id.'</u>';
	} elseif ($p == "5") { // VIP status
		$info .= '<div class="ok rad3">'.$vipother.'</div>'.$info2;
		$info .= _d('your user ID',988).'. ';
		$info .= _d('We\'ll activate your VIP status for you',989).'.<br />';
		$info .= _d('Your USER ID',990).': <u>'.$id.'</u>';
	} elseif ($p == "6") { // agency registration
		$info .= '<div class="ok rad3">'.$agregother.'</div>'.$info2;
		$info .= _d('your profile url',980).'. ';
		$info .= _d('We\'ll activate your account for you',991).'.';
	} elseif ($p == "7") { // agency adding escort
		$info .= '<div class="ok rad3">'.$agescortregother.'</div>'.$info2;
		$info .= _d('your profile url',980).'. ';
		$info .= _d('We\'ll activate your account for you',991).'.';
	} elseif ($p == "8") { // independent escort registration
		$info .= '<div class="ok rad3">'.$indescregother.'</div>'.$info2;
		$info .= _d('your profile url',980).'. ';
		$info .= _d('We\'ll activate your account for you',991).'.';
	}
	$info .= '</div> <!-- err -->';
	return $info;
}
function generate_ccbill_button($p, $id, $text) {
	global $payment_options_a, $current_user;
	get_currentuserinfo();

	$ccbill_acc_nr = get_option("ccbill_acc_nr");
	$ccbill_subacc_nr = get_option("ccbill_subacc_nr");
	$ccbill_salt = get_option("ccbill_salt");
	$ccbill_form_name = get_option("ccbill_form_name");

	$form = array(
			// Variables required for both single and recurring transactions
			'clientAccnum' => $ccbill_acc_nr, // An integer value representing the 6-digit client account number
			'clientSubacc' => $ccbill_subacc_nr, // An integer value representing the 4-digit client subaccount number
			'formName' => $ccbill_form_name,
			'currencyCode' => get_option("ccbill_currency_code"), // USD //  An integer representing the 3-digit currency code that will be used for the transaction
			'formPeriod' => '365', // An integer representing the length, in days, of the initial billing period
			'productId' => $p,
			'language' => 'English',
			'email' => $current_user->user_email,
			'custom' => $id
		);

	if($p == "1") { // premium
		$ap_itemname = _d('Premium Position',634);
		$ap_description = _d('Buy Premium Position',636);
		$submit = _d('Buy Now',816);
		$form['formPrice'] = number_format(get_option("premiumprice"), 2, '.', ''); // A decimal value representing the initial price

		if(get_option("premiumsubscription") == "yes") {
			// Variables required for recurring transactions only
			$form['formRecurringPrice'] = $form['formPrice']; //  A decimal value representing the recurring billing price
			$form['formRecurringPeriod'] = $payment_options_a[get_option("premiumduration")][4]; // An integer representing the number of days between each rebill
			$form['formRebills'] = '99'; // Integer representing the total times the subscription will rebill. A value of 99 will rebill indefinitely
		}
		$form['formPeriod'] = $payment_options_a[get_option("premiumduration")][4]; // An integer representing the length, in days, of the initial billing period
	} elseif ($p == "2") { // featured
		$ap_itemname = _d('Featured Position',641);
		$ap_description = _d('Buy Featured Position',636);
		$submit = _d('Buy Now',816);
		$form['formPrice'] = number_format(get_option("featuredprice"), 2, '.', '');

		if(get_option("featuredsubscription") == "yes") {
			// Variables required for recurring transactions only
			$form['formRecurringPrice'] = $form['formPrice']; //  A decimal value representing the recurring billing price
			$form['formRecurringPeriod'] = $payment_options_a[get_option("featuredduration")][4]; // An integer representing the number of days between each rebill
			$form['formRebills'] = '99'; // Integer representing the total times the subscription will rebill. A value of 99 will rebill indefinitely
		}
			$form['formPeriod'] = $payment_options_a[get_option("featuredduration")][4];; // An integer representing the length, in days, of the initial billing period
	} elseif ($p == "3") { // tour
		$ap_itemname = _d('Activate tour',788);
		$ap_description = _d('Activate tour',788);
		$submit = _d('Pay for this tour',559);
		$form['formPrice'] = number_format(get_option("tourprice"), 2, '.', '');
	} elseif ($p == "4") { // unlock escort information
		$ap_itemname = _d('Unlock profile',876);
		$ap_description = _d('Unlock profile',876);
		$submit = _d('Unlock profile',876);
		$form['formPrice'] = number_format(get_option("vipprice"), 2, '.', '');
	} elseif ($p == "5") { // VIP status
		$ap_itemname = _d('Get VIP status',880);
		$ap_description = _d('Get VIP status',880);
		$submit = _d('Get VIP status',880);
		$form['formPrice'] = number_format(get_option("vipprice"), 2, '.', '');

		if(get_option("premiumsubscription") == "yes") {
			// Variables required for recurring transactions only
			$form['formRecurringPrice'] = $form['formPrice']; //  A decimal value representing the recurring billing price
			$form['formRecurringPeriod'] = $payment_options_a[get_option("vipduration")][4]; // An integer representing the number of days between each rebill
			$form['formRebills'] = '99'; // Integer representing the total times the subscription will rebill. A value of 99 will rebill indefinitely
		}
		$form['formPeriod'] = $payment_options_a[get_option("vipduration")][4]; // An integer representing the length, in days, of the initial billing period
		$ap_returnurl = get_bloginfo('url');
	} elseif ($p == "6") { // agency registration
		$ap_itemname = _d('Registration fee',925);
		$ap_description = _d('Registration fee',925);
		$submit = _d('Pay registration fee',926);
		$form['formPrice'] = number_format(get_option("agregprice"), 2, '.', '');

		if(get_option("agregsubscription") == "yes") {
			// Variables required for recurring transactions only
			$form['formRecurringPrice'] = $form['formPrice']; //  A decimal value representing the recurring billing price
			$form['formRecurringPeriod'] = $payment_options_a[get_option("agregduration")][4]; // An integer representing the number of days between each rebill
			$form['formRebills'] = '99'; // Integer representing the total times the subscription will rebill. A value of 99 will rebill indefinitely
		}
		$form['formPeriod'] = $payment_options_a[get_option("agregduration")][4]; // An integer representing the length, in days, of the initial billing period
	} elseif ($p == "7") { // agency adding escort
		$ap_itemname = _d('Registration fee',925);
		$ap_description = _d('Registration fee',925);
		$submit = _d('Pay registration fee',926);
		$form['formPrice'] = number_format(get_option("agescortregprice"), 2, '.', '');

		if(get_option("agescortregsubscription") == "yes") {
			// Variables required for recurring transactions only
			$form['formRecurringPrice'] = $form['formPrice']; //  A decimal value representing the recurring billing price
			$form['formRecurringPeriod'] = $payment_options_a[get_option("agescortregduration")][4]; // An integer representing the number of days between each rebill
			$form['formRebills'] = '99'; // Integer representing the total times the subscription will rebill. A value of 99 will rebill indefinitely
		}
		$form['formPeriod'] = $payment_options_a[get_option("agescortregduration")][4]; // An integer representing the length, in days, of the initial billing period
	} elseif ($p == "8") { // independent escort registration
		$ap_itemname = _d('Registration fee',925);
		$ap_description = _d('Registration fee',925);
		$submit = _d('Pay registration fee',926);
		$form['formPrice'] = number_format(get_option("indescregprice"), 2, '.', '');

		if(get_option("indescregsubscription") == "yes") {
			// Variables required for recurring transactions only
			$form['formRecurringPrice'] = $form['formPrice']; //  A decimal value representing the recurring billing price
			$form['formRecurringPeriod'] = $payment_options_a[get_option("indescregduration")][4]; // An integer representing the number of days between each rebill
			$form['formRebills'] = '99'; // Integer representing the total times the subscription will rebill. A value of 99 will rebill indefinitely
		}
		$form['formPeriod'] = $payment_options_a[get_option("indescregduration")][4]; // An integer representing the length, in days, of the initial billing period
	}

	if($text) { $submit = $text; } // if the function is being called with a custom text then change the button's text with this one

	// generate dynamic payment hash
	$hash = $form['formPrice'].$form['formPeriod'];
	if($form['formRecurringPrice']) {
		$hash .= $form['formRecurringPrice'].$form['formRecurringPeriod'].$form['formRebills'];
	}
	$hash .= $form['currencyCode'].$ccbill_salt;
	$form['formDigest'] = md5($hash);

	// Generate Payment Button
	$button = '<form method="post" action="https://bill.ccbill.com/jpost/signup.cgi">';
	foreach ($form as $key => $value) {
		$button .= '<input type="hidden" name="'.$key.'" value="'.$value.'">'."\n";
	}
		$button .= '<input type="submit" class="greenbutton payment-button rad3" name="submit" value="'.$submit.'" /><br />';
	$button .= '</form>';

	return $button;
}


function payment_canceled($customeremail, $paymenttype, $custom, $eventtype="1") {
	global $taxonomy_profile_name, $taxonomy_agency_name;

	$expiration = strtotime("+2 days") - 5;
	$emaillink = get_permalink($custom);
	$body = _d('Hello',17).'<br /><br />'._d('Your subscription from',1244).' '.get_option("email_sitename").' ';
	switch ($eventtype) {
		case '1': // Cancellation
				$subject = _d('was canceled',1245);
				$body .= _d('was canceled',1245).'.<br />';
				$update_expire = true;
				$delete_renew = true;
				$send_email = true;
			break;

		case '2': // Expiration
				$expiration = strtotime("-1 days");
				$send_email = false;
			break;

		case '3': // Refund / Chargeback / Return / Void
				$body = _d('Hello',17).'<br /><br />'._d('Your payment for',1246).' '.get_option("email_sitename").' ';
				$subject = _d('was refunded',1247);
				$body .= _d('was refunded',1247).'.<br />';
				$expiration = strtotime("-1 days");
				$send_email = true;
			break;
	}


	if ($paymenttype == "1") { // premium
		update_post_meta($custom, 'premium_expire', $expiration);
		delete_post_meta($custom, 'premium_renew');
	} elseif ($paymenttype == "2") { // featured
		update_post_meta($custom, 'featured_expire', $expiration);
		delete_post_meta($custom, 'featured_renew');
	} elseif ($paymenttype == "3") { // tour
		$post_tour = array( 'ID' => $custom, 'post_status' => 'draft' );
		wp_update_post( $post_tour );
		$body .= _d('This means we had to deactivate your tour and it won\'t be visible on our website anymore',1035).".<br />";
		$body .= _d('If you want to add another tour please visit our website',1036).":<br />";
	} elseif ($paymenttype == "4") { // unlock
		$custom = explode("-", $custom);
		$userid = $custom[0];
		$escortid = $custom[1];
		$unlocked_escorts = get_user_meta($userid, 'unlocked_escorts', true);
		unset($unlocked_escorts[$escortid]);
		update_user_meta($userid, 'unlocked_escorts', array_unique($unlocked_escorts));
		$body .= _d('This means we had to remove your access to the %s profile',1037,$taxonomy_profile_name).".<br />";
		$body .= _d('If you want to unlock the %s profile again please visit our website',1038,$taxonomy_profile_name).":<br />";
		$emaillink = get_permalink($custom[1]);
		$body .= '<a href="'.$emaillink.'">'.$emaillink.'</a>';
	} elseif ($paymenttype == "5") { // vip
		update_post_meta($custom, 'vip_expire', $expiration);
		delete_post_meta($custom, 'vip_renew');
		$body .= _d('This means your VIP status will only be active for 2 more days',1039).".<br />";
		$body .= _d('If you want to renew your status please visit our website',940).":<br />";
		$emaillink = get_bloginfo('url');
		$body .= '<a href="'.$emaillink.'">'.$emaillink.'</a>';
	} elseif ($paymenttype == "6") { // agency reg
		update_post_meta($custom, 'agency_expire', $expiration);
		delete_post_meta($custom, 'agency_renew');
	} elseif ($paymenttype == "7") { // agency adding escort
		update_post_meta($custom, 'escort_expire', $expiration);
		delete_post_meta($custom, 'escort_renew');
	} elseif ($paymenttype == "8") { // escort reg
		update_post_meta($custom, 'escort_expire', $expiration);
		delete_post_meta($custom, 'escort_renew');
	}

	if($send_email)
		dolce_email("", "", $customeremail, _d('Payment for',1248)." ".get_option("email_sitename")." ".$subject, $body);

	check_expired();
}
?>