<?php
/*
Template Name: Edit site settings
*/

global $current_user;
get_currentuserinfo();
if (!current_user_can('level_10')) { wp_redirect(get_bloginfo("url")); exit; }

	$err = "";
	$ok = "";
if (isset($_POST['action']) && $_POST['action'] == 'sitesettings') {
	$dolce_sitelang = substr(wp_filter_nohtml_kses($_POST['dolce_sitelang']), 0, 100);
	$blogname = wp_strip_all_tags($_POST['blogname']);
	$blogdescription = wp_strip_all_tags($_POST['blogdescription']);

	$manactivesc = (int)$_POST['manactivesc'];
	$manactivag = (int)$_POST['manactivag'];
	$manactivagprof = (int)$_POST['manactivagprof'];
	$manactivagescprof = (int)$_POST['manactivagescprof'];
	$manactivindescprof = (int)$_POST['manactivindescprof'];
	$manactivclassads = (int)$_POST['manactivclassads'];

	$allowadpostingprofiles = (int)$_POST['allowadpostingprofiles'];
	$allowadpostingagencies = (int)$_POST['allowadpostingagencies'];
	$allowadpostingmembers = (int)$_POST['allowadpostingmembers'];

	$newlabelperiod = (int)$_POST['newlabelperiod'];
	$maximgupload = (int)$_POST['maximgupload'];
	$maximguploadsize = (int)$_POST['maximguploadsize'];

	$allowvideoupload = (int)$_POST['allowvideoupload'];
	$maxvideoupload = (int)$_POST['maxvideoupload'];
	$maxvideouploadsize = (int)$_POST['maxvideouploadsize'];
	$videoresizeheight = (int)$_POST['videoresizeheight'];

	if(!$err) {
		update_option("dolce_sitelang", $dolce_sitelang);
		update_option("blogname", $blogname);
		update_option("blogdescription", $blogdescription);

		update_option("manactivesc", $manactivesc);
		update_option("manactivag", $manactivag);
		update_option("manactivagprof", $manactivagprof);
		update_option("manactivagescprof", $manactivagescprof);
		update_option("manactivindescprof", $manactivindescprof);
		update_option("manactivclassads", $manactivclassads);

		update_option("allowadpostingprofiles", $allowadpostingprofiles);
		update_option("allowadpostingagencies", $allowadpostingagencies);
		update_option("allowadpostingmembers", $allowadpostingmembers);

		update_option("newlabelperiod", $newlabelperiod);
		update_option("maximgupload", $maximgupload);
		update_option("maximguploadsize", $maximguploadsize);

		update_option("allowvideoupload", $allowvideoupload);
		update_option("maxvideoupload", $maxvideoupload);
		update_option("maxvideouploadsize", $maxvideouploadsize);
		update_option("videoresizeheight", $videoresizeheight);

		$ok = "ok";
	}
} else {
	$dolce_sitelang = get_option("dolce_sitelang");
	$blogname = get_option("blogname");
	$blogdescription = get_option("blogdescription");
	$showheaderslider = get_option("showheaderslider");

	$manactivesc = get_option("manactivesc");
	$manactivag = get_option("manactivag");
	$manactivagprof = get_option("manactivagprof");
	$manactivagescprof = get_option("manactivagescprof");
	$manactivindescprof = get_option("manactivindescprof");
	$manactivclassads = get_option("manactivclassads");

	$allowadpostingprofiles = get_option("allowadpostingprofiles");
	$allowadpostingagencies = get_option("allowadpostingagencies");
	$allowadpostingmembers = get_option("allowadpostingmembers");

	$newlabelperiod = get_option("newlabelperiod");
	$maximgupload = get_option("maximgupload");
	$maximguploadsize = get_option("maximguploadsize");

	$allowvideoupload = get_option("allowvideoupload") ? get_option("allowvideoupload") : '2';
	$maxvideoupload = get_option("maxvideoupload") ? get_option("maxvideoupload") : '4';
	$maxvideouploadsize = get_option("maxvideouploadsize") ? get_option("maxvideouploadsize") : '100';
	$videoresizeheight = get_option("videoresizeheight") ? get_option("videoresizeheight") : '400';
}

get_header(); ?>

	<div class="contentwrapper">
	<div class="body">
    	<div class="bodybox site-settings-page">
			<h3 class="settingspagetitle l"><?php _de('Edit site settings',167); ?></h3>
            <div class="clear"></div>
			<?php if ($err) { echo "<div class=\"err rad3\">$err</div>"; } ?>
			<?php if ($ok) { echo "<div class=\"ok rad3\">"._d('Your settings have been saved',168)."</div>"; } ?>
			<form action="<?php echo get_permalink(get_the_ID()); ?>" method="post" class="form-styling">
				<input type="hidden" name="action" value="sitesettings" />

				<div class="form-label">
					<label for="dolce_sitelang"><?php _de('Site language',169); ?></label>
				</div>
				<div class="form-input">
					<select name="dolce_sitelang" id="dolce_sitelang">
						<?php get_langs_list($dolce_sitelang); ?>
					</select>
				</div> <!-- language --> <div class="formseparator"></div>

				<div class="form-label">
					<label><?php _de('Site name',170); ?></label>
                </div>
				<div class="form-input">
					<input type="text" name="blogname" id="blogname" class="input longinput" value="<?php echo $blogname; ?>" />
				</div> <!-- blogname --> <div class="formseparator"></div>

				<div class="form-label">
					<label><?php _de('Site description',171); ?></label>
                </div>
				<div class="form-input">
					<input type="text" name="blogdescription" id="blogdescription" class="input longinput" value="<?php echo $blogdescription; ?>" />
				</div> <!-- --> <div class="formseparator"></div>

				<script type="text/javascript">
				jQuery(document).ready(function($) {
				    $('#file_upload').uploadifive({
						'auto'           : true,
						'buttonClass'    : 'bluebutton rad5 l',
						'buttonText'     : '<?php _de('Upload logo',1069) ?>',
						'fileSizeLimit'  : '5MB',
				        'fileType'       : 'image/*',
				        'formData'       : { 'folder' : '<?php echo get_option("secret_to_upload_site_logo"); ?>' },
						'multi'          : false,
						'queueID'        : 'upload-queue',
						'queueSizeLimit' : 1,
						'removeCompleted': true,
						'simUploadLimit' : 1,
						'uploadLimit'    : 100,
						'uploadScript'   : '<?php bloginfo('template_url'); ?>/ajax/upload-site-logo-process.php',
						'onAddQueueItem': function(data) {
							$('.showsitelogo').slideUp('slow');
						},
						'onQueueComplete': function(data) {
							$.ajax({
								type: "GET",
								url: "<?php bloginfo('template_url'); ?>/ajax/get-site-logo-url.php",
								data: "id=" + '1',
								success: function(data){
									$('#status-message').hide().html('<'+'div class="ok rad3"><?php _de('Your image has been uploaded',173); ?><'+'/div>').delay(500).slideDown("slow").delay(5000).slideUp("slow");
									$('.showsitelogo').html('<'+'img src="'+data+'" alt="" id="uploaded_logo_img">').slideDown('slow', function() {
										$('.logo h1 a').animate({
											height: $('#uploaded_logo_img').height(),
											opacity: 0},
											1000, function() {
											$(this).html('<'+'img src="'+data+'" alt="<?php echo get_bloginfo('name'); ?>">').animate({opacity: 1}, 500);
										});
									});

									$('.deletesitelogo').show();
								}
							});
						}
					});

					//delete site logo
					$('.deletesitelogo').on('click', function(){
						$('.showsitelogo').slideUp("slow");
						$('.deletesitelogo').fadeOut(500);
						$.ajax({
							type: "GET",
							url: "<?php bloginfo('template_url'); ?>/ajax/delete-site-logo.php",
							data: "id=" + '1',
							success: function(data){
								$('#status-message').hide().html('<'+'div class="ok rad3"><?php _de('Your image has been deleted',174); ?><'+'/div>').slideDown("slow").delay(5000).slideUp("slow");
								$('.logo h1 a').slideUp('slow').html('<?php echo get_bloginfo('name'); ?>').slideDown('slow');
							}
						});
					});
				});
				</script>

				<div class="form-label">
					<label><?php _de('Site logo',172); ?></label>
                </div>
				<div class="form-input">
					<div class="upload_photos_button l"><input id="file_upload" name="file_upload" type="hidden" />&nbsp;&nbsp;&nbsp;</div>
					<div class="redbutton rad5 r deletesitelogo<?php if(!get_option("sitelogo")) { echo ' hide'; } ?>" style=""><?php _de('Delete Logo',1088); ?></div>

				</div> <!-- upload logo --> <div class="formseparator"></div>

				<div id="upload-queue"></div><div id="status-message"></div>
				<div class="showsitelogo rad5 center<?php if(!get_option("sitelogo")) { echo ' hide'; } ?>">
					<?php if(get_option("sitelogo")) { echo '<img src="'.get_option("sitelogo").'" alt="" />'; } ?>
				</div>

				<div class="form-input col100">
					<small><i>!</i> <?php _de('If a logo is already uploaded and you upload a new one then the old one is automatically deleted',176); ?></small>
				</div> <!-- --> <div class="formseparator"></div>

				<div class="clear30"></div>

				<div class="form-label">
			    	<label><?php _de('Manually activate reviews for %s?',201,$taxonomy_profile_name_plural); ?></label>
			    </div>
				<div class="form-input">
				    <label for="manactivescyes"><input type="radio" name="manactivesc" value="1" id="manactivescyes"<?php if($manactivesc == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
		    		<label for="manactivescno"><input type="radio" name="manactivesc" value="2" id="manactivescno"<?php if($manactivesc == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
					<small><i>!</i> <?php _de('If you choose "yes" you will be notified by email each time someone<br />adds a new review. The email will have a link to the review',202); ?>.</small>
			    </div> <!-- manually activate escorts --> <div class="formseparator"></div>

			    <div class="form-label">
			    	<label><?php _de('Manually activate reviews for %s?',203,$taxonomy_agency_name_plural); ?></label>
			    </div>
				<div class="form-input">
				    <label for="manactivagyes"><input type="radio" name="manactivag" value="1" id="manactivagyes"<?php if($manactivag == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="manactivagno"><input type="radio" name="manactivag" value="2" id="manactivagno"<?php if($manactivag == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label><br />
					<small><i>!</i> <?php _de('If you choose "yes" you will be notified by email each time someone<br />adds a new review. The email will have a link to the review',202); ?>.</small>
			    </div> <!-- manually activate agencies --> <div class="formseparator"></div>

			    <div class="form-label">
			    	<label><?php _de('Manually activate new %s profiles?',840,$taxonomy_agency_name); ?></label>
			    </div>
				<div class="form-input">
				    <label for="manactivagprofyes"><input type="radio" name="manactivagprof" value="1" id="manactivagprofyes"<?php if($manactivagprof == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="manactivagprofno"><input type="radio" name="manactivagprof" value="2" id="manactivagprofno"<?php if($manactivagprof == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
					<small><i>!</i> <?php _de('If you choose "yes" you will have to activate each profile manually',843); ?>.</small>
			    </div> <!-- --> <div class="formseparator"></div>

			    <div class="form-label">
			    	<label><?php _de('Manually activate new %s added by %s?',841,array($taxonomy_profile_name_plural,$taxonomy_agency_name_plural)); ?></label>
			    </div>
				<div class="form-input">
				    <label for="manactivagescprofyes"><input type="radio" name="manactivagescprof" value="1" id="manactivagescprofyes"<?php if($manactivagescprof == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="manactivagescprofno"><input type="radio" name="manactivagescprof" value="2" id="manactivagescprofno"<?php if($manactivagescprof == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
					<small><i>!</i> <?php _de('If you choose "yes" you will have to activate each profile manually',843); ?>.</small>
			    </div> <!-- --> <div class="formseparator"></div>

			    <div class="form-label">
			    	<labe><?php _de('Manually activate new independent %s?',842,$taxonomy_profile_name_plural); ?></label>
			    </div>
				<div class="form-input">
				    <label for="manactivindescprofyes"><input type="radio" name="manactivindescprof" value="1" id="manactivindescprofyes"<?php if($manactivindescprof == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="manactivindescprofno"><input type="radio" name="manactivindescprof" value="2" id="manactivindescprofno"<?php if($manactivindescprof == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
					<small><i>!</i> <?php _de('If you choose "yes" you will have to activate each classified ad manually',1264); ?>.</small>
			    </div> <!-- manually activate independent escorts --> <div class="formseparator"></div>

			    <div class="form-label">
			    	<labe><?php _de('Manually activate new classified ads?',1263); ?></label>
			    </div>
				<div class="form-input">
				    <label for="manactivclassadsyes"><input type="radio" name="manactivclassads" value="1" id="manactivclassadsyes"<?php if($manactivclassads == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="manactivclassadsno"><input type="radio" name="manactivclassads" value="2" id="manactivclassadsno"<?php if($manactivclassads == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
					<small><i>!</i> <?php _de('If you choose "yes" you will have to activate each profile manually',843); ?>.</small>
			    </div> <!-- manually activate independent escorts --> <div class="formseparator"></div>

				<div class="form-label">
					<label><?php _de('What user types can post classified ads?',1265); ?></label>
			    </div>
				<div class="form-input">
				    <label for="allowadpostingprofiles">
			        	<input type="checkbox" name="allowadpostingprofiles" value="1" id="allowadpostingprofiles"<?php if($allowadpostingprofiles == "1") { echo ' checked'; } ?> /> 
			            <?=ucfirst($taxonomy_profile_name_plural)?>
						</label><div class="clear5"></div>
				    <label for="allowadpostingagencies">
			        	<input type="checkbox" name="allowadpostingagencies" value="1" id="allowadpostingagencies"<?php if($allowadpostingagencies == "1") { echo ' checked'; } ?> /> 
			            <?=ucfirst($taxonomy_agency_name_plural)?>
					</label><div class="clear5"></div>
				    <label for="allowadpostingmembers">
		    	    	<input type="checkbox" name="allowadpostingmembers" value="1" id="allowadpostingmembers"<?php if($allowadpostingmembers == "1") { echo ' checked'; } ?> /> 
			            <?php _de('Normal users',1266); ?>
					</label><div class="clear5"></div>
			    </div> <!-- --> <div class="formseparator"></div>

				<div class="form-label">
					<label for="newlabelperiod"><?php _de('New %s label period',1227,$taxonomy_profile_name); ?></label>
                </div>
				<div class="form-input">
					<input type="text" name="newlabelperiod" id="newlabelperiod" class="input text-center" size="3" maxlength="3" value="<?php echo $newlabelperiod; ?>" /> days
					<small><i>!</i> <?=_d('new %s profiles will have the NEW label if they have registered less then X days ago',1229,$taxonomy_profile_name)?></small>
				</div> <!-- --> <div class="formseparator"></div>

				<div class="clear30"></div>

				<fieldset class="fieldset rad5">
					<legend class="rad3"><?php _de('Images settings',1272); ?></legend>
					<div class="form-label">
						<label for="maximgupload"><?php _de('Maximum number of images a %s can upload',1228,$taxonomy_profile_name); ?></label>
	                </div>
					<div class="form-input">
						<input type="text" name="maximgupload" id="maximgupload" class="input" size="3" maxlength="3" value="<?php echo $maximgupload; ?>" /> <?=_d('images',1257)?>
					</div> <!-- --> <div class="formseparator"></div>

					<div class="form-label">
						<label for="maximguploadsize"><?php _de('Maximum size per image',1230); ?></label>
	                </div>
					<div class="form-input">
						<input type="text" name="maximguploadsize" id="maximguploadsize" class="input" size="3" maxlength="2" value="<?php echo $maximguploadsize; ?>" /> MB
					</div>	
				</fieldset>

				<div class="clear30"></div>

				<fieldset class="fieldset rad5">
					<legend class="rad3"><?php _de('Video settings',1273); ?></legend>
				    <div class="form-label">
				    	<labe><?php _de('Allow video upload?',1253); ?></label>
				    </div>
					<div class="form-input">
					    <label for="allowvideouploadyes"><input type="radio" name="allowvideoupload" value="1" id="allowvideouploadyes"<?php if($allowvideoupload == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
				    	<label for="allowvideouploadno"><input type="radio" name="allowvideoupload" value="2" id="allowvideouploadno"<?php if($allowvideoupload == "2" || !$allowvideoupload) { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
				    	<div class="clear10"></div>
					    <?php
					    if(function_exists(shell_exec)) {
						    $ffmpeg = trim(shell_exec('ffmpeg -version'));
						    if($ffmpeg) {
						    	echo "<span class='ok rad3'>"._d('ffmpeg is installed',1276)."</span><div class='clear15'></div>";
						    } else {
						    	echo "<span class='err rad3'>"._d('You need to install ffmpeg first',1277)."</span><div class='clear15'></div>";
						    }
					    } else {
					    	echo "<span class='err rad3'>"._d('You need to enable shell_exec',1278)."</span><div class='clear15'></div>";
					    }
					    ?>
				    </div> <!-- allow video --> <div class="formseparator"></div>

					<div class="form-label">
						<label for="maxvideoupload"><?php _de('Maximum number of videos allowed',1254); ?></label>
	                </div>
					<div class="form-input">
						<input type="text" name="maxvideoupload" id="maxvideoupload" class="input" size="3" maxlength="2" value="<?php echo $maxvideoupload; ?>" /> <?=_d('videos',1256)?>
					</div> <!-- --> <div class="formseparator"></div>

					<div class="form-label">
						<label for="maxvideouploadsize"><?php _de('Maximum video size',1255); ?></label>
	                </div>
					<div class="form-input">
						<input type="text" name="maxvideouploadsize" id="maxvideouploadsize" class="input" size="3" maxlength="2" value="<?php echo $maxvideouploadsize; ?>" /> MB
						<div class="clear10"></div>
					    <?php
					    $upload_max_filesize = ini_get('upload_max_filesize');
					    if((int)$upload_max_filesize > $maxvideouploadsize) {
					    	echo "<span class='ok rad3'>upload_max_filesize is ".$upload_max_filesize."</span><div class='clear15'></div>";
					    } else {
					    	echo "<span class='err rad3'>upload_max_filesize is ".$upload_max_filesize."</span><div class='clear15'></div>";
					    }

					    $post_max_size = ini_get('post_max_size');
					    if((int)$post_max_size > $maxvideouploadsize) {
					    	echo "<span class='ok rad3'>post_max_size is ".$post_max_size."</span><div class='clear15'></div>";
					    } else {
					    	echo "<span class='err rad3'>post_max_size is ".$post_max_size."</span><div class='clear15'></div>";
					    }
					    ?>
					</div> <!-- --> <div class="formseparator"></div>

				    <div class="form-label">
				    	<label><?php _de('Resize uploaded videos at',1274); ?></label>
				    </div>
					<div class="form-input">
    					<select name="videoresizeheight">
							<option value="300"<? if($videoresizeheight == "300") { echo ' selected="selected"'; } ?>>300px</option>
							<option value="400"<? if($videoresizeheight == "400") { echo ' selected="selected"'; } ?>>400px</option>
							<option value="500"<? if($videoresizeheight == "500") { echo ' selected="selected"'; } ?>>500px</option>
							<option value="600"<? if($videoresizeheight == "600") { echo ' selected="selected"'; } ?>>600px</option>
						</select>
						<?=_d('in height',1279)?>
				    </div> <!-- --> <div class="formseparator"></div>
				</fieldset>

				<div class="clear30"></div>
				<div class="center"><input type="submit" name="submit" value="<?php _de('Save settings',1008); ?>" class="bluebutton rad3" /></div> <!--center-->
			</form>
			<div class="clear"></div>
		</div> <!-- BODY BOX -->
	</div> <!-- BODY -->
    </div> <!-- contentwrapper -->

	<?php get_sidebar("left"); ?>
	<?php get_sidebar("right"); ?>
	<div class="clear"></div>

<?php get_footer(); ?>