<?php
if(!defined('error_reporting')) { define('error_reporting', '0'); }
ini_set( 'display_errors', error_reporting );
if(error_reporting == '1') { error_reporting( E_ALL ); }
if(isdolcetheme !== 1) { die(); }


global $taxonomy_location_url, $taxonomy_agency_url, $taxonomy_profile_url;
if ($_POST['tourcountry'] > 0) {
	$tourcountry = (int)$_POST['tourcountry'];
	$tourcity_parent = $tourcountry;
	if (!term_exists( $tourcountry, $taxonomy_location_url )) {
		$err .= _d('The country you selected doesn\'t exist in our database',61)."<br />"; unset($tourcountry);
	} else {
		if(showfield('state')) {
			if ($_POST['tourstate']) {
				if(get_option('locationdropdown') == "1") { // if location is a dropdown
					$tourstate = (int)$_POST['tourstate'];
					$tourstate_id = get_term_by('id', $tourstate, $taxonomy_location_url);
					if (!$tourstate_id) {
						$err .= _d('The state you selected doesn\'t exist in our database',1213)."<br />"; unset($tourstate);
					}
					$tourstate_id = $tourstate_id->term_id;
				} else {
					$tourstate = substr(sanitize_text_field($_POST['tourstate']), 0, 70);
					$tourstate_id = term_exists( $tourstate, $taxonomy_location_url, $tourcountry );
					if (!$tourstate_id) {
						$arg = array('description' => $tourstate, 'parent' => $tourcountry);
						wp_insert_term($tourstate, $taxonomy_location_url, $arg);
						$tourstate_id = term_exists( $tourstate, $taxonomy_location_url, $tourcountry );
					}
					$tourstate_id = $tourstate_id['term_id'];
				}
					$tourcity_parent = $tourstate_id;
			} else {
				$err .= _d('You need to select your state',1208)."<br />"; unset($tourstate);
			} // if post[tourstate]			
		} // if showfield('state')

		if ($_POST['tourcity']) {
			if(get_option('locationdropdown') == "1") { // if location is a dropdown
				$tourcity = (int)$_POST['tourcity'];
				$tourcity_id = get_term_by('id', $tourcity, $taxonomy_location_url);
				if (!$tourcity_id) {
					$err .= _d('The city you selected doesn\'t exist in our database',62)."<br />"; unset($tourcity);
				}
				$tourcity_id = $tourcity_id->term_id;
			} else {
				$tourcity = substr(sanitize_text_field($_POST['tourcity']), 0, 70);
				$tourcity_id = term_exists( $tourcity, $taxonomy_location_url, $tourcity_parent);
				if (!$tourcity_id) {
					$arg = array('description' => $tourcity, 'parent' => $tourcity_parent);
					wp_insert_term($tourcity, $taxonomy_location_url, $arg);
					$tourcity_id = term_exists( $tourcity, $taxonomy_location_url, $tourcity_parent);
				}
				$tourcity_id = $tourcity_id['term_id'];
			}
		} else {
			$err .= _d('You need to select your city',506)."<br />"; unset($tourcity);
		} // if post[city]
	} // if term exists country
} else {
	$err .= _d('You need to select a country',102)."<br />"; unset($tourcountry);
}

$start = preg_replace("/([^0-9\/])/", "", $_POST['start']);
if ($start) {
	$start = explode("/", $start);
	if (count($start) != 3) {
		$err .= _d('The start date seems to be wrong',549)."<br />"; unset($start);
	}
	$start = mktime(0, 0, 0, $start[1], $start[0], $start[2]);
} else {
	$err .= _d('You have to select a start date for the tour',550)."<br />";
}

$end = preg_replace("/([^0-9\/])/", "", $_POST['end']);
if ($end) {
	$end = explode("/", $end);
	if (count($end) != 3) {
		$err .= _d('The end date seems to be wrong',551)."<br />"; unset($start);
	}
	$end = mktime(23, 59, 59, $end[1], $end[0], $end[2]);
} else {
	$err .= _d('You have to select the end date for the tour',552)."<br />";
}

if($start > $end) {
	$err .= _d('The end date must be after your start date',553)."<br />"; unset($end);
}

$tourphone = wp_strip_all_tags($_POST['tourphone'], true);
if (!$tourphone) { $err .= _d('Please write your phone number',96)."<br />"; }

if ($_POST['tourid']) {
	$tourid = (int)$_POST['tourid'];

	global $current_user;
	get_currentuserinfo();
	$userid = $current_user->ID;

	$escort = get_post(get_post_meta( $tourid, 'belongstoescortid', true));
	$escort_author = $escort->post_author;

	if ($escort_author != $userid && !current_user_can('level_10')) {
		$err .= _d('You are not allowed to edit this tour',554);
	}
}

if ($_POST['belongstoescortid']) {
	$belongstoescortid = (int)$_POST['belongstoescortid'];
	$escort = get_post($belongstoescortid);
	$escort_author = $escort->post_author;

	if ($escort_author != $userid && !current_user_can('level_10')) {
		$err .= _d('You are not allowed to add tours here',555);
	}
}


if ( !$err ) {
	global $current_user;
	get_currentuserinfo();

	if (get_option("tourprice") && get_option("paymentgateway") && !$tourid && !current_user_can('level_10')) {
		$post_status = "private";
	} else {
		$post_status = "publish";
	}

	$tour_escort = array(
		'post_title' => _d('Tour to',791).' '." $tourcity",
		'post_content' => "",
		'post_status' => $post_status,
		'post_author' => $current_user->ID,
		'post_type' => 'tour',
		'ping_status' => 'closed'
	);

	if ($tourid) {
		$tour_escort_id = $tourid;
	} else {
		$tour_escort_id = wp_insert_post( $tour_escort );
	}
	wp_set_post_terms($tour_escort_id, $tourcity_id, $taxonomy_location_url);
	update_post_meta($tour_escort_id, "country", $tourcountry);
	if(showfield('state')) {
		update_post_meta($tour_escort_id, "state", $tourstate_id);
	}
	update_post_meta($tour_escort_id, "city", $tourcity_id);
	update_post_meta($tour_escort_id, "start", $start);
	update_post_meta($tour_escort_id, "end", $end);
	update_post_meta($tour_escort_id, "phone", $tourphone);

	if($post_status == "private") {
		update_post_meta($tour_escort_id, "needs_payment", '1');
	}

	$userid = $current_user->ID;
	$userstatus = get_option("escortid".$userid);
	if(!$tourid) {
		if ($userstatus == $taxonomy_agency_url) {
			update_post_meta($tour_escort_id, "belongstoescortid", $belongstoescortid);
		} elseif ($userstatus == $taxonomy_profile_url) {
			$addto_post_id = get_option("escortpostid".$userid);
			update_post_meta($tour_escort_id, "belongstoescortid", $addto_post_id);
		} else {
			update_post_meta($tour_escort_id, "belongstoescortid", $escort->ID);
		}
	}

	if ($is_escort_page == "yes") {
		//wp_redirect(get_permalink($escort_post_id_for_tours)."#tours"); exit;
	}
	unset($tourcountry, $tourstate, $tourcity, $tourcity_id, $start, $end, $tourphone);
	if ($tourid) {
		$ok = _d('The tour has been updated',556);
	} else {
		$ok = _d('The tour has been added',557);
		if (get_option("tourprice") && get_option("paymentgateway") && !current_user_can('level_10')) {
			$ok .= "<br /><br />"._d('In order for the tour to be activated you must pay',558)." ".format_price('3', "yes")."<br />"."\n";
			$ok .= generate_payment_buttons('3',$tour_escort_id);
		}
	}
}
?>