<?php
if(!defined('error_reporting')) { define('error_reporting', '0'); }
ini_set( 'display_errors', error_reporting );
if(error_reporting == '1') { error_reporting( E_ALL ); }
if(isdolcetheme !== 1) { die(); }

global $current_user;
get_currentuserinfo();

if (isset($_POST['action']) && current_user_can('level_10')) {
	$install_profile_name = str_replace("-", " ", sanitize_title(char_to_utf8($_POST['install_profile_name'])));
	if(!$install_profile_name) {
		$err .= "Não há nome para os perfis individuais<br />";
	}

	$install_profile_name_plural = str_replace("-", " ", sanitize_title(char_to_utf8($_POST['install_profile_name_plural'])));
	if(!$install_profile_name_plural) {
		$err .= "Não há nome para os perfis individuais no plural<br />";
	}

	$install_profile_url = sanitize_title(char_to_utf8($_POST['install_profile_url']));
	if(!$install_profile_url) {
		$err .= "Não há nenhum URL de perfil individual<br />";
	}

	$install_gender = $_POST['install_gender'];
	if(!$install_gender || !is_array($install_gender)) {
		$err .= "Escolha sua lista de gêneros<br />";
	} else {
		global $gender_a;
		foreach ($install_gender as $key=>$gender) {
			if(!array_key_exists($gender, $gender_a)) {
				unset($install_gender[$key]);
			}
		}
	}

	$install_agency_name = str_replace("-", " ", sanitize_title(char_to_utf8($_POST['install_agency_name'])));
	if(!$install_agency_name) {
		$err .= "Não há nome para os perfis da agência<br />";
	}

	$install_agency_name_plural = str_replace("-", " ", sanitize_title(char_to_utf8($_POST['install_agency_name_plural'])));
	if(!$install_agency_name_plural) {
		$err .= "Não há nome para perfis de agências no plural<br />";
	}

	$install_agency_url = sanitize_title(char_to_utf8($_POST['install_agency_url']));
	if(!$install_agency_url) {
		$err .= "Não há nenhum URL de agência<br />";
	}

	$install_location = (int)$_POST['install_location'];
	if(!$install_location) {
		$err .= "Escolha quais países você deseja usar no tema<br />";
	}

	if($install_location == "2") {
		$install_countries = trim($_POST['install_countries']);
		if(!$install_countries) {
			$err .= "Você escolhe escrever seus próprios países manualmente, mas o campo de países está vazio<br />";
		}
	}

	$install_location_url = sanitize_title(char_to_utf8($_POST['install_location_url']));
	if(!$install_location_url) {
		$err .= "Não há URL para países e cidades<br />";
	}

	if(!$err) {
		update_option("taxonomy_profile_name", strtolower($install_profile_name));
		update_option("taxonomy_profile_name_plural", strtolower($install_profile_name_plural));
		update_option("taxonomy_profile_url", strtolower($install_profile_url));

		update_option("taxonomy_agency_name", strtolower($install_agency_name));
		update_option("taxonomy_agency_name_plural", strtolower($install_agency_name_plural));
		update_option("taxonomy_agency_url", strtolower($install_agency_url));

		update_option("settings_theme_genders", $install_gender);
		update_option("taxonomy_location_url", strtolower($install_location_url));

		//create pages
		if (get_option('are_all_pages_created') != 'yes') {
	    	$pages_created_count = create_theme_pages();
			$ok .= '<p><span class="icon icon-ok"></span> '.$pages_created_count.' páginas foram criadas</p>';
		} else {
			$ok .= '<p><span class="icon icon-ok"></span> 0 páginas foram criadas. Páginas já existem.</p>';
		}

		//create initial country list
		if($install_location == "1") { //add the full country list
			import_country_list($install_location_url);
			$ok .= '<p><span class="icon icon-ok"></span> 232 países foram criados</p>';
		} elseif ($install_location == "2") { //add the custom country list that the admin wrote
			create_country_list($install_countries, $install_location_url);
			$ok .= '<p><span class="icon icon-ok"></span> '.count(explode("\n", trim($install_countries))).' países foram criados</p>';
		}
		update_option('are_all_countries_imported', 'yes');

	    if (get_option('defaults_have_been_set') != 'yes') {
			set_default_settings();
			$ok .= '<p><span class="icon icon-ok"></span> As configurações padrão foram definidas</p>';
		} else {
			$ok .= '<p><span class="icon icon-ok"></span> As configurações padrão já estão definidas</p>';
		}

		update_option('is_theme_installed', 'yes');

		flush_rewrite_rules();
	} // if !$err
} // if isset($_POST['action'])

if (current_user_can('level_10')) { ?>
	<script type="text/javascript">
	jQuery(document).ready(function($) {
		$('#location').change(function() {
			location();
		});
		location();
		function location(){
			var location = $('#location').val();
			if (location == "1") {
				$('.location-option').hide();
				$('.location1').show();
			} else if (location == "2") {
				$('.location-option').hide();
				$('.location2').show();
			} else if (location == "") {
				$('.location-option').hide();
			}
		}

		<?php if(isset($_POST['action'])) { ?>
			var install_profile_url_has_been_edited = 'yes';
			var install_agency_name_plural_has_been_edited = 'yes';
		<?php } else { ?>
			var install_profile_url_has_been_edited = null;
			var install_agency_name_plural_has_been_edited = null;
		<?php } ?>

		$('#install_profile_name').keyup(function(){
			var install_profile_name = $.trim($(this).val());
			$('#install_profile_name_plural').val(install_profile_name+"s");
			if(install_profile_url_has_been_edited != 'yes') {
				install_profile_name = install_profile_name.replace(/ /g,"-");
				$('#install_profile_url').val(install_profile_name);
				$('#install_location_url').val(install_profile_name+'s-from')
			}
		});

		$('#install_agency_name').keyup(function(){
			var install_agency_name = $(this).val();
			install_agency_name = $.trim(install_agency_name).replace(/ /g,"-");
			$('#install_agency_url').val(install_agency_name);
			if(install_agency_name_plural_has_been_edited != 'yes') {
				$('#install_agency_name_plural').val('');
			}
		});

		$('#install_profile_url').keyup(function(){ install_profile_url_has_been_edited = 'yes'; });
		$('#install_agency_name_plural').keyup(function(){ install_agency_name_plural_has_been_edited = 'yes'; });

		$("#install_form").submit(function() {
			if(!$(this).attr('ajax_done')) {
				$.get( "<?php bloginfo('template_url') ?>/ajax/settings-saver.php", {
					taxonomy_location_url: $('#install_location_url').val(), 
					taxonomy_profile_url: $('#install_profile_url').val()
				}).done(function(data) {
					$("#install_form").attr('ajax_done', true);
					$("#install_form").submit();
				});
				$(".submit-button").hide();
				loader('.install_submit_button');
				$('.install_submit_button').append('Por favor, espere...');
				return false;
			}
		});
	});
	</script>
<?php } // if admin ?>
	<div class="logo"><img src="<?=get_bloginfo('template_url')?>/i/logo.png" /></div>
	<div class="clear10"></div>
	<div class="install rad3">
		<?php if (!current_user_can('level_10')) { ?>
			<h3>Assistente de Configuração de Tema</h3>
		    <p>Somente administradores podem instalar o tema.</p>
		    <p>Se você é o administrador deste site, por favor <a href="<?php echo wp_login_url(get_bloginfo('url')); ?>">Clique aqui para logar</a> primeiro.</p>
		<?php } else { ?>
		    <form action="" method="post" name="install_form" id="install_form">
			    <?php if($ok) { ?>
			    	<div class="ok rad3">Seu tema foi configurado com sucesso</div>
			    	<?php echo $ok; ?>
					<div class="clear20"></div>
					<a href="<?php bloginfo('url'); ?>/" class="bluebutton rad25"><b>Vá para o seu site</b></a>
					<div class="clear"></div>
			    <?php } else { ?>
		    	<h3>Assistente de Configuração de Tema</h3>
			    <p>Esta é a primeira vez que você está vendo o tema.</p>
			    <p>Nós recomendamos que você instale este tema em uma instalação Limpa do WordPress (o que significa que você não usou este site antes para qualquer outra coisa).</p>
			    <p>Para que o tema funcione corretamente, primeiro precisamos que você escolha algumas configurações importantes para o seu futuro site.</p>
			    <p>Percorra todas as opções abaixo e configure o seu tema.</p>
			    <p>Se você não tem certeza sobre uma determinada opção, basta usar as informações pré-preenchidas.</p>

				<?php if($err) { echo '<div class="err rad3">'.$err.'</div>'; } ?>

			    <input type="hidden" name="action" value="install_theme" />

			    <div class="clear30"></div>
			    <div class="col50 l">
				    <div class="label">O nome para perfis individuais (singular):</div>
					<div class="help">ex: escort, modelo, perfil, acompanhate, massagista etc</div>
				</div>
				<div class="col50 l">
					<input type="text" class="input rad3 center" name="install_profile_name" id="install_profile_name" value="<?php if($install_profile_name || isset($_POST['action'])) { echo $install_profile_name; } else { echo 'escort'; } ?>" style="width: 250px" />
				</div>

			    <div class="clear30"></div>
			    <div class="col50 l">
				    <div class="label">O plural para o nome acima.<br />Usado quando há mais de um perfil:</div>
					<div class="help">ex: escorts, modelos, perfis, acompanhates, massagistas etc</div>
				</div>
				<div class="col50 l">
					<input type="text" class="input rad3 center" name="install_profile_name_plural" id="install_profile_name_plural" value="<?php if($install_profile_name_plural || isset($_POST['action'])) { echo $install_profile_name_plural; } else { echo 'escorts'; } ?>" style="width: 250px" />
				</div>
				<div class="clear10"></div>
			    <div>
					<div class="help center"><i class="reddegrade rad5">&nbsp;!&nbsp;</i> esses nomes serão usados em menus e títulos, então precisamos tanto do singular quanto do plural do nome do perfil</div>
				</div>

			    <div class="clear40"></div>
			    <div class="col30 l">
				    <div class="label">URL do perfil:</div>
				    <div class="help">para perfis individuais</div>
				</div>
				<div class="col70 l">
				    <?php bloginfo('url') ?>/ <input type="text" class="input rad3 center" name="install_profile_url" id="install_profile_url" value="<?php if($install_profile_url || isset($_POST['action'])) { echo $install_profile_url; } else { echo 'escort'; } ?>" style="width: 150px" /> /garota-safadinha/
				</div>


			    <div class="clear50"></div>
			    <div class="col50 l">
				    <div class="label">Quais gêneros você deseja permitir para os perfis individuais:</div>
				    <div class="help"></div>
				</div>
				<div class="col50 l">
				    <label for="gender_female" class="label-checkbox"><input type="checkbox" name="install_gender[]" id="gender_female" value="1" <?php if(in_array('1', $install_gender) || !$install_gender && !isset($_POST['action'])) { echo 'checked="checked" '; } ?> /> Garotas</label><div class="clear5"></div>
				    <label for="gender_male" class="label-checkbox"><input type="checkbox" name="install_gender[]" id="gender_male" value="2" <?php if(in_array('2', $install_gender) || !$install_gender && !isset($_POST['action'])) { echo 'checked="checked" '; } ?>/> Garotos</label><div class="clear5"></div>
				    <label for="gender_couple" class="label-checkbox"><input type="checkbox" name="install_gender[]" id="gender_couple" value="3" <?php if(in_array('3', $install_gender) || !$install_gender && !isset($_POST['action'])) { echo 'checked="checked" '; } ?>/> Casais</label><div class="clear5"></div>
				    <label for="gender_gay" class="label-checkbox"><input type="checkbox" name="install_gender[]" id="gender_gay" value="4" <?php if(in_array('4', $install_gender) || !$install_gender && !isset($_POST['action'])) { echo 'checked="checked" '; } ?>/> Gay</label><div class="clear5"></div>
				    <label for="gender_trans" class="label-checkbox"><input type="checkbox" name="install_gender[]" id="gender_trans" value="5" <?php if(in_array('5', $install_gender) || !$install_gender && !isset($_POST['action'])) { echo 'checked="checked" '; } ?>/> Transsexual</label>
				</div>

				<div class="clear50"></div>
				<div class="col50 l">
				    <div class="label">O nome dos perfis de agência:</div>
					<div class="help">ex: agencia, studio etc</div>
				</div>
				<div class="col50 l">
				    <input type="text" class="input rad3 center" name="install_agency_name" id="install_agency_name" value="<?php if($install_agency_name || isset($_POST['action'])) { echo $install_agency_name; } else { echo 'agency'; } ?>" style="width: 250px" />
				</div>

				<div class="clear50"></div>
				<div class="col50 l">
				    <div class="label">O plural para o nome acima.<br />Usado quando há mais de um perfil de agência:</div>
					<div class="help">ex: agencias, studios etc</div>
				</div>
				<div class="col50 l">
				    <input type="text" class="input rad3 center" name="install_agency_name_plural" id="install_agency_name_plural" value="<?php if($install_agency_name_plural || isset($_POST['action'])) { echo $install_agency_name_plural; } else { echo 'agencies'; } ?>" style="width: 250px" />
				</div>
				<div class="clear10"></div>
			    <div>
					<div class="help center"><i class="reddegrade rad5">&nbsp;!&nbsp;</i> esses nomes serão usados menus e títulos, então precisamos tanto do singular quanto do plural do nome do perfil da agência</div>
				</div>

			    <div class="clear40"></div>
			    <div class="col30 l">
				    <div class="label">URL do perfil da agência:</div>
				    <div class="help">para perfis de agência</div>
				</div>
				<div class="col70 l">
				    <?php bloginfo('url') ?>/ <input type="text" class="input rad3 center" name="install_agency_url" id="install_agency_url" value="<?php if($install_agency_url || isset($_POST['action'])) { echo $install_agency_url; } else { echo 'agency'; } ?>" style="width: 150px" /> /some-nome/
				</div>


				<div class="clear50"></div>
				<div class="col50 l">
					<div class="label">Quais países você deseja usar:</div>
					<div class="help">
						Podemos importar uma lista completa de todos os países do mundo para você.<br />
						Se você preferir adicionar seus próprios países (somente da Brasil, por exemplo), escreva-os manualmente.
					</div>
				</div>
				<div class="col50 l">
					<select class="select rad3 col90" name="install_location" id="location">
						<option value="">Escolha a opção</option>
						<option value="1"<?php if($install_location == "1") { echo ' selected="selected"'; } ?>>Todos os países</option>
						<option value="2"<?php if($install_location == "2") { echo ' selected="selected"'; } ?>>Escreva os países manualmente</option>
					</select>
				</div>
				<div class="help col50 r location1 location-option hide">
					<div class="clear5"></div>
					Nós vamos importar uma lista de 232 países para você.<br />
					Você pode editar a lista do seu painel do WordPress depois de concluir a configuração.
				</div>
				<div class="location2 location-option hide">
					<div class="clear20"></div>
					<div class="col40 l">
						<div class="label">Sua lista de países:</div>
						<div class="help">Escreva um país por linha</div>
					</div>
					<div class="col60 l">
						<textarea name="install_countries" class="textarea rad3 col90"><?php if($install_countries || isset($_POST['action'])) { echo $install_countries; } else { echo "Germany\nFrance\nSpain"; } ?></textarea>
					</div>
				</div>

			    <div class="clear30"></div>
			    <div class="col30 l">
				    <div class="label">País &amp; cidade url:</div>
				    <div class="help">ex: acompanhantes-de</div>
				</div>
				<div class="col70 l">
				    <?php bloginfo('url') ?>/ <input type="text" class="input rad3 center" name="install_location_url" id="install_location_url" value="<?php if($install_location_url || isset($_POST['action'])) { echo $install_location_url; } else { echo 'escorts-from'; } ?>" style="width: 150px" /> /brasil/
				</div>

				<div class="clear50"></div>
				<div class="install_submit_button"><input type="submit" name="submit" value="Save configuration" class="bluebutton rad25 submit-button" /></div>
				<div class="clear"></div>
			</form>
		<?php
			} // if !$ok
		} // if admin
		?>
	</div> <!-- install -->
	<div class="clear40"></div>
</body>
</html>