<?php
/*
Template Name: Edit Registration Form for Escorts
*/

global $current_user;
get_currentuserinfo();
if (!current_user_can('level_10')) { wp_redirect(get_bloginfo("url")); exit; }

$err = ""; $ok = "";
$fields = get_option('regfieldsescort');
if (isset($_POST['action']) && $_POST['action'] == 'editregformescorts') {
	/*
	[key] 'inputname'
	[0] 'name'
	[1] 'showinreg'
	[2] 'mandatory'
	[3] 'useinsearch'

	LEGEND for showinreg, mandatory, useinsearch
	1 = yes
	2 = no
	3 = yes, can't edit
	4 = no, can't edit
	*/
	foreach($fields as $key=>$f) {
		if($fields[$key][1] != "3" && $fields[$key][1] != "4") {
			if($_POST[$key.'showinreg'] == "1") { $fields[$key][1] = '1'; } else { $fields[$key][1] = '2'; }
		}
		if($fields[$key][1] != "2") {
			if($fields[$key][2] != "3" && $fields[$key][2] != "4") {
				if($_POST[$key.'mandatory'] == "1") { $fields[$key][2] = '1'; } else { $fields[$key][2] = '2'; }
			}
			if($fields[$key][3] != "3" && $fields[$key][3] != "4") {
				if($_POST[$key.'useinsearch'] == "1") { $fields[$key][3] = '1'; } else { $fields[$key][3] = '2'; }
			}
		} else {
			if($fields[$key][2] != "3" && $fields[$key][2] != "4") {
				$fields[$key][2] = '2';
			}
			if($fields[$key][3] != "3" && $fields[$key][3] != "4") {
				$fields[$key][3] = '2';
			}
		}
	}

	if(!$err) {
		update_option("regfieldsescort", $fields);
		if(isset($_POST['reset'])) {
			$fields = $escortregfields;
			update_option("regfieldsescort", $fields);
		}
		$ok = "ok";
	}
}

get_header(); ?>

	<div class="contentwrapper">
	<div class="body">
    	<div class="bodybox edit-registration-content">
			<h3 class="settingspagetitle l"><?php _de('Edit Registration Form for %s',1007,ucwords($taxonomy_profile_name_plural)); ?></h3>
            <div class="clear"></div>
			<script type="text/javascript">
			jQuery(document).ready(function($) {
				var elems = Array.prototype.slice.call(document.querySelectorAll('.ios-checkbox'));

				elems.forEach(function(html) {
				  var switchery = new Switchery(html, { color: '#41cb59', size: 'medium' });
				});
			});
			</script>

			<?php if ($err) { echo "<div class=\"err rad3\">$err</div>"; } ?>
			<?php if ($ok) { echo "<div class=\"ok rad3\">"._d('Your settings have been saved',168)."</div>"; } ?>
			<form action="<?php echo get_permalink(get_the_ID()); ?>" method="post">
				<input type="hidden" name="action" value="editregformescorts" />
				<div class="clear10"></div>
				<table class="editregfields">
					<tr class="tabletop">
						<th><?php _de('Field name',1010); ?></th>
						<th><?php _de('Show in registration page',1011); ?></th>
						<th><?php _de('Mandatory',1012); ?></th>
						<th><?php _de('Use in search page',1013); ?></th>
					</tr>
					<?php
						$i = "1";
						foreach($fields as $key => $field) {
							if($i % 2) { $class = ' class="grayrow"'; }
							echo '<tr'.$class.'>';
							echo '<td class="alignleft">'.$field[0].'</td>';
							echo '<td>'.build_checkbox_edit_fields_page($field[1], $key, "1").'</td>';
							echo '<td>'.build_checkbox_edit_fields_page($field[2], $key, "2").'</td>';
							echo '<td>'.build_checkbox_edit_fields_page($field[3], $key, "3").'</td>';
							echo '</tr>';
							$i++; unset($class);
						}
					?>
				</table>

				<div class="clear20"></div>
				<div class="center">
					<input type="submit" name="submit" value="<?php _de('Save settings',1008); ?>" class="submit-button bluebutton rad25" />
					<div class="clear30"></div>
					<input type="submit" name="reset" value="<?php _de('Restore Defaults',1009); ?>" class="redbutton rad25" />
				</div>
			</form>
			<div class="clear"></div>
		</div> <!-- BODY BOX -->
	</div> <!-- BODY -->
    </div> <!-- contentwrapper -->

	<?php get_sidebar("left"); ?>
	<?php get_sidebar("right"); ?>
	<div class="clear"></div>

<?php get_footer(); ?>