<?php
ini_set( 'display_errors', 0 );

require( '../../../wp-load.php' );

if (!empty($_FILES)) {
	$secret = explode("/", $_REQUEST['folder']);
	$secret = $secret[(count($secret)-1)];
	$secret = preg_replace("/([^a-zA-Z0-9])/", "", $secret);
	//check if an agency added this post
	$escort_post_id = get_option("agency".$secret);

	if ($escort_post_id) {
		//this means the article was added by an agency
	} elseif (get_option($secret)) {
		//this means the article was added by an escort
		$escort_user_id = get_option($secret);
		$escort_post_id = get_option("escortpostid".$escort_user_id);
	} else {
		//if we don't find a secret added by an agency and neither by an independent escort then we die()
		die('We couldn\'t find a profile');
	}

	//checking the number of uploaded photos
	$photos = get_children( array('post_parent' => $escort_post_id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => 'ASC', 'orderby' => 'menu_order ID') );
	if (count($photos) >= get_option('maximgupload')) { die(); }

	//Get the Size of the File
	$size_bytes = get_option('maximguploadsize') * 1024 * 1024; //5MB
	$file_size = $_FILES['Filedata']['size'];

	//Make sure that file size is correct
	if ($file_size > $size_bytes){ die("The file is too large"); }
	if ($file_size == "0"){ die("The file can't have 0Kb"); }


	//check file extension
	$allowed_extensions = array("gif","png","jpg","jpeg");
	$image_mime_type = getimagesize($_FILES['Filedata']['tmp_name']);
	$extension = str_replace("image/", "", $image_mime_type['mime']);

	//if the image is too small we'll enlarge it
	if($image_mime_type[0] < "182" || $image_mime_type[1] < "270") {
		//part of the code is from: http://www.geekality.net/2011/05/01/php-how-to-proportionally-resize-an-uploaded-image/?PHPSESSID=9ec8489x682228k287ok4hz229z03noe8hd9igh9
		if($extension == "jpeg") {
    	    $image = imagecreatefromjpeg($_FILES['Filedata']['tmp_name']);
    	} elseif ($extension == "png") {
    	    $image = imagecreatefrompng($_FILES['Filedata']['tmp_name']);
		} elseif ($extension == "gif") {
    	    $image = imagecreatefromgif($_FILES['Filedata']['tmp_name']);
		} else {
			die("Unsupported type");
		}

		// Target dimensions
		$max_width = "182";
		$max_height = "270";

		// Get current dimensions
		$old_width  = imagesx($image);
		$old_height = imagesy($image);

		// Calculate the scaling we need to do to fit the image inside our frame
		$scale = max($max_width/$old_width, $max_height/$old_height);

		// Get the new dimensions
		$new_width  = ceil($scale*$old_width);
		$new_height = ceil($scale*$old_height);

		// Create new empty image
		$new = imagecreatetruecolor($new_width, $new_height);

		// Resize old image into new
		imagecopyresampled($new, $image, 0, 0, 0, 0, $new_width, $new_height, $old_width, $old_height);
		//replace temp image with the resized one

   	    imagejpeg($new, $_FILES['Filedata']['tmp_name'], 99);
   	    $extension = "jpg";
	} // if the image is too small

	//creating the upload directory path and the filename
	$extension = str_replace("jpeg", "jpg", $extension);
	$upload_folder = get_post_meta($escort_post_id, "upload_folder", true);
	if(!$upload_folder) { die("No upload folder specified in custom meta field"); }
	$tempFile = $_FILES['Filedata']['tmp_name'];
	$targetPath = ABSPATH . 'wp-content/uploads/'.$upload_folder;
	$targetFile =  time().rand(1000, 9999).".".$extension;

	if ((!in_array($extension,$allowed_extensions))) { die("Wrong file extension"); }
	if (!is_dir($targetPath)) {
		if (!mkdir($targetPath, 0777, true)) { die('Failed to create folder for the images!'); }
	}

	if (move_uploaded_file($tempFile,$targetPath."/".$targetFile)) {
		$attachment = array(
			'post_mime_type' => $image_mime_type['mime'],
			'guid' => content_url()."/uploads/".$upload_folder."/".$targetFile,
			'post_status' => 'inherit',
			'post_parent' => $escort_post_id,
			'post_title' => $targetFile,
			'post_type ' => "attachment"
		);

		// Save the attachment metadata
		require_once( ABSPATH . 'wp-admin/includes/image.php' );
		$attachment_id = wp_insert_attachment($attachment, $targetPath."/".$targetFile, $escort_post_id);
		$attach_data = wp_generate_attachment_metadata($attachment_id, $targetPath."/".$targetFile);
		wp_update_attachment_metadata($attachment_id, $attach_data);
		echo 'ok';
	}
}
?>