<?php
if(!defined('error_reporting')) { define('error_reporting', '0'); }
ini_set( 'display_errors', error_reporting );
if(error_reporting == '1') { error_reporting( E_ALL ); }
if(isdolcetheme !== 1) { die(); }

global $current_user, $taxonomy_location_url, $taxonomy_agency_name, $taxonomy_agency_url;
get_currentuserinfo();

if ($_POST['agency_post_id']) {
	$agency_post_id = (int)$_POST['agency_post_id'];

	$agency_post = get_post($agency_post_id);
	$agency_post_author = $agency_post->post_author;

	if ($agency_post_author != $current_user->ID && !current_user_can('level_10')) {
		$err .= _d('You are not allowed to edit this profile',497)."<br />";
	}
}

if(!$agency_post_id) {
    $user = preg_replace("/([^a-zA-Z0-9])/", "", $_POST['user']);
	if ($user) {
		if (strlen($user) < 4 || strlen($user) > 30) { $err .= _d('Your username must be between 4 and 30 characters',498)."<br />"; } else {
			if (username_exists($user)) { $err .= _d('This username already exists. Please write another one',499)."<br />"; }
		}
	} else {
		$err .= _d('The username field is empty',500)."<br />";
	}


	$pass = $_POST['pass'];
	if ($pass) {
		if (strlen($pass) < 6 || strlen($pass) > 50) {
			$err .= _d('Your password must be between 6 and 50 characters',464)."<br />";
		} else {
			if ( false !== strpos( stripslashes($pass), "\\" ) ) {
				$err .= _d('Passwords may not contain the character "\"',785)."<br />";
			}
		}
	} else {
		$err .= _d('The password field is empty',466)."<br />";
	}
}

$agencyemail = $_POST['agencyemail'];
if (!$agencyemail) { $err .= _d('Please write your email address',501)."<br />"; } else {
	if ( !is_email($agencyemail) ) { $err .= _d('Your email address seems to be wrong',561)."<br />"; }
	if ( email_exists($agencyemail) && $agencyemail != get_the_author_meta('user_email', $agency_post_author) ) {
		$err .= _d('This email address has already been used by someone else',502)."<br />";
		if ($agency_post_id) {
			$agencyemail = get_the_author_meta('user_email', $agency_post_author);
		}
	}
}

if(current_user_can('level_10')) {
	$sendverification = (int)$_POST['sendverification'];
	$sendauth = (int)$_POST['sendauth'];
} else {
	unset($sendverification, $sendauth);
}

$agencyname = wp_strip_all_tags($_POST['agencyname'], true);
if (!$agencyname) { $err .= _d('Please write your %s name',503,$taxonomy_agency_name)."<br />"; }


$phone = substr(wp_strip_all_tags($_POST['phone'], true), 0, 50);
if (!$phone) { $err .= _d('Please write your phone number',504)."<br />"; }


if ($_POST['website']) {
	$website = substr(esc_url($_POST['website'], array('http', 'https')), 0 , 300);
	if (!$website) {
		$err .= _d('Your website url seems to be wrong',505)."<br />";
	}
} elseif (ismand('website', 'no')) {
	$err .= _d('Please write a website url for your profile',1014)."<br />";
}

if ($_POST['country'] && $_POST['country'] > 0) {
	$country = (int)$_POST['country'];
	$city_parent = $country;
	if (!term_exists( $country, $taxonomy_location_url )) {
		$err .= _d('The country you selected doesn\'t exist in our database',61)."<br />"; unset($country);
	} else {
		if(showfield('state')) {
			if ($_POST['state']) {
				if(get_option('locationdropdown') == "1") { // if location is a dropdown
					$state = (int)$_POST['state'];
					$state_id = get_term_by('id', $state, $taxonomy_location_url);
					if (!$state_id) {
						$err .= _d('The state you selected doesn\'t exist in our database',1213)."<br />"; unset($state);
					}
					$state_id = $state_id->term_id;
				} else {
					$state = substr(sanitize_text_field($_POST['state']), 0, 70);
					$state_id = term_exists( $state, $taxonomy_location_url, $country );
					if (!$state_id) {
						$arg = array('description' => $state, 'parent' => $country);
						wp_insert_term($state, $taxonomy_location_url, $arg);
						$state_id = term_exists( $state, $taxonomy_location_url, $country );
					}
					$state_id = $state_id['term_id'];
				}
					$city_parent = $state_id;
			} else {
				$err .= _d('You need to select your state',1208)."<br />"; unset($state);
			} // if post[state]			
		} // if showfield('state')

		if ($_POST['city']) {
			if(get_option('locationdropdown') == "1") { // if location is a dropdown
				$city = (int)$_POST['city'];
				$city_id = get_term_by('id', $city, $taxonomy_location_url);
				if (!$city_id) {
					$err .= _d('The city you selected doesn\'t exist in our database',62)."<br />"; unset($city);
				}
				$city_id = $city_id->term_id;
			} else {
				$city = substr(sanitize_text_field($_POST['city']), 0, 70);
				$city_id = term_exists( $city, $taxonomy_location_url, $city_parent);
				if (!$city_id) {
					$arg = array('description' => $city, 'parent' => $city_parent);
					wp_insert_term($city, $taxonomy_location_url, $arg);
					$city_id = term_exists( $city, $taxonomy_location_url, $city_parent);
				}
				$city_id = $city_id['term_id'];
			}
		} else {
			$err .= _d('You need to select your city',506)."<br />"; unset($city);
		} // if post[city]
	} // if term exists country
} else {
	$err .= _d('You need to select a country',102)."<br />"; unset($country);
}

$aboutagency = substr(stripslashes(wp_kses($_POST['aboutagency'], array())), 0, 5000);
if (!$aboutagency) { $err .= _d('You must write something about the %s',507,$taxonomy_agency_name)."<br />"; }

//spam/emails field must be empty to continue
$emails = $_POST['emails'];
if ($emails != "") { $err = ".<br />"; }

if(get_option('recaptcha_sitekey') && get_option('recaptcha_secretkey') && !is_user_logged_in() && get_option("recaptcha3")) { $err .= verify_recaptcha(); }

if (!$err) {
	if ($agency_post_id) {
		$new_user_id = $agency_post_author;
	} else {
		$new_user_id = wp_create_user( $user, $pass, $agencyemail );
		//set an email hash so the user needs to validate his email in order to use the site
		if(!current_user_can('level_10') || $sendverification == "1") {
			$emailhash = md5($new_user_id.$user.$agencyemail);
			update_user_meta( $new_user_id, "emailhash",  $emailhash);
		}
	}
	wp_update_user( array ('ID' => $new_user_id, 'nickname' => $agencyname, 'display_name' => $agencyname, 'user_url' => $website) );

	if (!$agency_post_id) {
		//adding the id in the database and the type of user it is, escort or agency, so we can check later what privileges they have
		update_option("escortid".$new_user_id, $taxonomy_agency_url);
	}


	if ($agency_post_id) {
		// Create post object
		$post_agency = array(
			'ID' => $agency_post_id,
			'post_title' => $agencyname,
			'post_name' => $agencyname,
			'post_content' => $aboutagency
		);
		//update the post
		wp_update_post( $post_agency );
		$post_agency_id = $agency_post_id;
	} else {
		$post_status = "publish";
		if (get_option("manactivagprof") == 1) {
			$post_status = "private"; //setting the profile to private until the admin activates the account
		}

		if ($sendverification == "1") {
			$post_status = "private"; //setting the profile to draft until the user validates his email
		} elseif(get_option('agregprice') && get_option('paymentgateway')) {
			$post_status = "private";
		}

		// Create post object
		$post_agency = array(
			'post_title' => $agencyname,
			'post_content' => $aboutagency,
			'post_status' => $post_status,
			'post_author' => $new_user_id,
			'post_type' => $taxonomy_agency_url,
			'ping_status' => 'closed'
		);
		// Insert the post into the database
		$post_agency_id = wp_insert_post( $post_agency );

		if(!current_user_can('level_10') && get_option("manactivagprof") == "1") {
			update_post_meta($post_agency_id, "notactive", "1"); //requires admin activation
		} // if not admin

		update_post_meta($post_agency_id, "ip", getenv('REMOTE_ADDR'));
		update_post_meta($post_agency_id, "hostname", gethostbyaddr($_SERVER['REMOTE_ADDR']));
	}

	update_post_meta($post_agency_id, "phone", $phone);
	update_post_meta($post_agency_id, "country", $country);
	if(showfield('state')) {
		update_post_meta($post_agency_id, "state", $state_id);
	}
	update_post_meta($post_agency_id, "city", $city_id);
	if (!$agency_post_id) {
		$secret = md5($agencyemail.$user.time().rand(1,999));
		update_post_meta($post_agency_id, "secret", $secret);
		update_post_meta($post_agency_id, "upload_folder", time().rand(1,999));
		if(get_option("agregprice") && !current_user_can('level_10') && get_option("paymentgateway")) {
			update_post_meta($post_agency_id, "needs_payment", "1");
		}

		//add the post id where this agency keeps all the info and images
		update_option("agencypostid".$new_user_id, $post_agency_id);
		update_option($secret, $new_user_id);


		if(!current_user_can('level_10') || $sendverification == "1") {
			$emailtext = _d('Before you can use the site you will need to validate your email address.',795).'
'._d('If you don\'t validate your email in the next 3 days your account will be deleted.',960).'<br /><br />
'._d('Please validate your email address by clicking the link bellow',1025).':
<a href="'.get_bloginfo('url').'/?ekey='.$emailhash.'">'.get_bloginfo('url').'/?ekey='.$emailhash.'</a><br /><br />';
		} else {
			$emailtext = _d('Your account is now active on',508).' '.get_option("email_sitename").'<br /><br />';
		}

		if(!current_user_can('level_10') || $sendverification == "1") {
			$emailtitle = _d('Email validation link',1026);
		} else {
			$emailtitle = _d('Welcome to',515);
		}

		if($sendauth == "1") {
		} else {
			$pass = '('._d('hidden',462).')';
		}

		//send email to agency
		$body = _d('Hello',17).' '.$agencyname.'<br /><br />
'.$emailtext.'
'._d('Account information',509).':<br />
'._d('type',510).': <b>'.$taxonomy_agency_name.'</b><br />
'._d('username',512).': <b>'.$user.'</b><br />
'._d('password',513).': <b>'.$pass.'</b><br /><br />
'._d('You can view your account here',514).':<br />
<a href="'.get_permalink($post_agency_id).'">'.get_permalink($post_agency_id).'</a>';
		dolce_email("", "", $agencyemail, $emailtitle." ".get_option("email_sitename"), $body);

		if ($admin_adding_agency == "yes") {
			wp_redirect(get_permalink($post_agency_id)); exit;
		} else {
			wp_clear_auth_cookie(); //delete the cookies of the user if he is already logged in. for example if he is the admin
			wp_set_auth_cookie($new_user_id, true, ''); //add login cookies to the user so we can identify him
			wp_redirect(get_permalink(get_option('agency_reg_page_id'))); exit;
		}
	} else {
		if ($admin_adding_agency == "yes") {
			wp_redirect(get_permalink($post_agency_id)); exit;
		}

		$ok = "ok";
	}
	
}
?>